#!/usr/bin/python3
from flask import Flask, jsonify, render_template
from app import monitor
from config.settings import SERVER_HOST, SERVER_PORT

app = Flask(__name__)

# 1. API 接口：只负责读历史数据
@app.route('/api/data')
def api_data():
    # 调用刚才写的新函数，查最近20条
    history_data = monitor.get_history_data(limit=20)
    
    # 返回的是一个列表 [{}, {}, {}]，前端就能画线了！
    return jsonify(history_data)

# 2. 首页：只负责显示页面
@app.route('/')
def index():
    # 这里的 data 参数其实前端没用到，删掉也没关系，为了不报错先留着空字典
    return render_template('index.html', data={})

def start_server():
    print(f"🔥 ServerMonitor 启动中... http://{SERVER_HOST}:{SERVER_PORT}")
    app.run(host=SERVER_HOST, port=SERVER_PORT, debug=True) # debug=True 方便看报错

if __name__=='__main__':
    start_server()
